var searchResultProvider = new SearchResultsProvider("ALT", "AutoLISP Tutorial");
searchResultProvider.setTopicInfoList(["",{"title":"Introduction",
"href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c45.htm",
"description":"This tutorial is designed to demonstrate several powerful capabilities of the AutoLISP® programming environment for AutoCAD® and introduce features of the AutoLISP language that may be new to you.",
"ancestors":[]},
{"title":"Working in Visual LISP",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72fe.htm",
"description":"This tutorial assumes you have some familiarity with LISP or AutoLISP. It also assumes you understand basic Windows® file management tasks such as creating directories, copying files, and navigating through the file system on your hard disk or network. If you need a primer on using AutoCAD, please explore the User’s Guide for more information.",
"ancestors":[{"title": "Introduction","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c45.htm"}]},
{"title":"Tutorial Overview",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72fb.htm",
"description":"Your goal in this tutorial is to develop a new command for AutoCAD that draws a garden path and fills it with circular tiles. The tutorial is divided into seven lessons. As you progress from lesson to lesson, you receive progressively less detailed instructions on how to perform individual tasks. Help is available in the VLISP documentation if you have any questions.",
"ancestors":[{"title": "Introduction","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c45.htm"}]},
{"title":"Designing and Beginning the Program",
"href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm",
"description":"In this first lesson, you\'ll begin by defining what the application will do. Using the Visual LISP® (VLISP) development environment, you\'ll create a LISP file and begin writing AutoLISP® code to support your application. In the process, you\'ll begin to discover how VLISP facilitates application development.",
"ancestors":[]},
{"title":"Defining Overall Program Goals",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-731c.htm",
"description":"Developing an AutoLISP program begins with an idea for automating some aspect of AutoCAD®. It may be a need to speed up a repetitive drafting function, or to simplify a complex series of operations. For the tutorial, the garden path you want your program to draw is a complex shape with a variable number of components, based on initial input from the user. Here\'s what it will look like:",
"ancestors":[{"title": "Designing and Beginning the Program","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm"}]},
{"title":"Getting Started with Visual LISP",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7316.htm",
"description":"Now that you\'ve seen how the application is supposed to work, you can begin developing it with VLISP. But first, it helps to demonstrate what can happen when VLISP is waiting for control to return from AutoCAD. You may have already encountered this.",
"ancestors":[{"title": "Designing and Beginning the Program","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm"}]},
{"title":"Looking at Visual LISP Code Formatting",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7310.htm",
"description":"VLISP recognizes the various types of characters and words that make up an AutoLISP program file and highlights the characters in different colors. This makes it easier for you to spot something incorrect quickly. For example, if you miss a closing quotation mark following a text string, everything you type continues to display in magenta, the color denoting strings. When you enter the closing quotation mark, VLISP correctly colors the text following the string, according to the language element it represents.",
"ancestors":[{"title": "Designing and Beginning the Program","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm"}]},
{"title":"Analyzing the Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-730f.htm",
"description":"The defun function statement defines the new function. Notice the main function is named C:GPath. The C: prefix establishes that this function is callable from the AutoCAD command line. GPath is the name users enter to launch the application from the AutoCAD Command prompt. The functions that obtain input from users are named gp:getPointInput and gp:getDialogInput. The function that draws the garden path outline is gp:drawOutline. These names are prefixed with gp: to indicate they are specific to the garden path application. This is not a requirement, but it is a good naming convention to use to distinguish application-specific functions from general utility functions you frequently use.",
"ancestors":[{"title": "Designing and Beginning the Program","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm"}]},
{"title":"Filling the Gaps in the Program",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-730e.htm",
"description":"For the code in this new file to work correctly, you must write three more function definitions. The main garden path code contains calls to three custom functions:",
"ancestors":[{"title": "Designing and Beginning the Program","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm"}]},
{"title":"Letting Visual LISP Check Your Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-730a.htm",
"description":"VLISP has a powerful feature for checking your code for syntactical errors. Use this tool before trying to run the program. You can catch common typing errors, such as missing parentheses or missing quotation marks, and other syntactical problems.",
"ancestors":[{"title": "Designing and Beginning the Program","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm"}]},
{"title":"Running the Program with Visual LISP",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7304.htm",
"description":"Running AutoLISP programs in VLISP allows you to use the many debugging features of VLISP to investigate problems that may occur in your application.",
"ancestors":[{"title": "Designing and Beginning the Program","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm"}]},
{"title":"Wrapping Up Lesson 1",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7300.htm",
"description":"In this lesson, you",
"ancestors":[{"title": "Designing and Beginning the Program","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5c3a.htm"}]},
{"title":"Using Visual LISP Debugging Tools",
"href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm",
"description":"This lesson teaches you how to use several valuable Visual LISP® debugging tools that speed up the development of AutoLISP® programs. You will also learn the difference between local and global variables, and when to use them. Your program will become more active—prompting users to enter some information. The information will be stored in a list and you\'ll begin to understand the power of using lists within your AutoLISP programs. After all, LISP got its name because it is a LISt Processing language.",
"ancestors":[]},
{"title":"Differentiating Between Local and Global Variables",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7358.htm",
"description":"This lesson discusses the use of local variables versus global document variables. Global variables are accessible by all functions loaded within a document (an AutoCAD® drawing). These variables may retain their value after the program that defined them completes. Sometimes, this is what you want. You\'ll see an example of this later in the tutorial.",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"}]},
{"title":"Using Local Variables in the Program",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7356.htm",
"description":"Refer to the gp:getPointInput function you created in Lesson 1:",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"},{"title": "Differentiating Between Local and Global Variables","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7358.htm"}]},
{"title":"Examining the gp:getPointInput Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7353.htm",
"description":"When you ran the gp:getPointInput function, control was automatically passed from VLISP to AutoCAD. You responded to three prompts, after which control was passed back from AutoCAD to VLISP, and a T symbol displayed in the Console window.",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"},{"title": "Differentiating Between Local and Global Variables","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7358.htm"}]},
{"title":"Using Association Lists to Bundle Data",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-734f.htm",
"description":"The previous example works, but you can do better. In the next exercise, you will build an association list, or assoc list (after the LISP function that deals with association lists). In an association list, the values you are interested in are associated with key values. Here is a sample association list:",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"}]},
{"title":"Putting Association Lists to Use",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-734e.htm",
"description":"When you use association lists, you should document what your key values represent. For the garden path, the key values of 10, 11, 40, 41, and 50 will mean the following:",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"},{"title": "Using Association Lists to Bundle Data","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-734f.htm"}]},
{"title":"Storing the Return Value of gp:getPointInput in a Variable",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-734c.htm",
"description":"Now try something else. Call the function again, but this time store the return value in a variable named gp_PathData. To do this, enter the following at the Console window prompt:",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"},{"title": "Using Association Lists to Bundle Data","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-734f.htm"}]},
{"title":"Examining Program Variables",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-734b.htm",
"description":"VLISP provides you with an entire toolkit of programming and debugging tools. One of the most valuable tools is a Watch, which lets you examine variables in more detail than appears in the VLISP Console window. You can also watch local variables within functions as the function executes.",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"}]},
{"title":"Revising the Program Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7344.htm",
"description":"Now that you\'ve seen how to use association lists in AutoLISP code, you can use this method in writing the completed version of the gp:getPointInput function. Using the following code, replace or modify the version of gp:getPointInput you previously saved in gpmain.lsp.",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"}]},
{"title":"Commenting Program Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7341.htm",
"description":"VLISP treats any AutoLISP statement beginning with a semicolon as a comment. The last two code examples contained a lot of comments. A comment in an AutoLISP program is something you write for yourself, not for the program. Commenting code is one of the best programming practices you can establish for yourself. Why write comments?",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"}]},
{"title":"Setting a Breakpoint and Using More Watches",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-733f.htm",
"description":"A breakpoint is a symbol (point) you place in source code to indicate where you want a program to stop executing temporarily. When you run your code, VLISP proceeds normally until it encounters a breakpoint. At that point, VLISP suspends execution and waits for you to tell it what to do. It hasn\'t halted the program for good—it has placed it in a state of suspended animation.",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"}]},
{"title":"Using the Debug Toolbar",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-733d.htm",
"description":"The Debug toolbar contains several tools you will employ as you work through this section. By default, this toolbar is attached to the View and Tools toolbars, and appears as a single VLISP toolbar.",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"},{"title": "Setting a Breakpoint and Using More Watches","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-733f.htm"}]},
{"title":"Stepping Through Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7332.htm",
"description":"There are three buttons you can use to step through your code. These are the three left-most icons on the Debug toolbar. In sequence, they represent the following actions:",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"},{"title": "Setting a Breakpoint and Using More Watches","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-733f.htm"}]},
{"title":"Watching Variables As You Step Through a Program",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-732c.htm",
"description":"While you step through your program, you can add variables to the Watch window and change their values.",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"},{"title": "Setting a Breakpoint and Using More Watches","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-733f.htm"}]},
{"title":"Stepping Out of the gp:getPointInput Function and into C:Gpmain",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7326.htm",
"description":"There is one more point to illustrate: what happens to the value of the local variables in gp:getPointInput after you exit the function.",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"},{"title": "Setting a Breakpoint and Using More Watches","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-733f.htm"}]},
{"title":"Wrapping Up Lesson 2",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-731e.htm",
"description":"In this lesson, you",
"ancestors":[{"title": "Using Visual LISP Debugging Tools","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5bc5.htm"}]},
{"title":"Drawing the Path Boundary",
"href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm",
"description":"In this lesson, you will expand your program so it actually draws something within AutoCAD—the polyline outline of the garden path. To draw the border, you must create some utility functions that are not specific to a single application but are general in nature and may be recycled for later use. You will also learn about writing functions that accept arguments—data that is passed to the function from the outside—and why the use of arguments is a powerful programming concept. By the end of the lesson, you will draw an AutoCAD shape parametrically, which means dynamically drawing a shape based on the unique data parameters provided by the user.",
"ancestors":[]},
{"title":"Planning Reusable Utility Functions",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-737e.htm",
"description":"Utility functions perform tasks common to many applications you will be writing. These functions form a toolkit you can use over and over again.",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"}]},
{"title":"Converting Degrees to Radians",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-737d.htm",
"description":"You will now create a function to prevent you from repetitively typing an equation. It looks like this:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Planning Reusable Utility Functions","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-737e.htm"}]},
{"title":"Converting 3D Points to 2D Points",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-737a.htm",
"description":"Another useful function in the garden path program converts 3D points to 2D points. AutoCAD usually works with 3D coordinates, but some entities, such as lightweight polylines, are always meant to be 2D. The points returned by the getpoint function are 3D, so you need to create a function to convert them.",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Planning Reusable Utility Functions","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-737e.htm"}]},
{"title":"Drawing AutoCAD Entities",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7377.htm",
"description":"Most AutoLISP programs draw entities using one of several methods:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"}]},
{"title":"Creating Entities Using ActiveX Functions",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7375.htm",
"description":"The newest way of creating entities is by using the ActiveX functions within VLISP. ActiveX has several advantages over entmake and command.",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Drawing AutoCAD Entities","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7377.htm"}]},
{"title":"Using entmake to Build Entities",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7373.htm",
"description":"The entmake function allows you to build an entity by gathering values for things such as coordinate location and orientation, layer, and color into an association list, then asking AutoCAD to build the entity for you. The association list you build for the entmake function looks very much like the association list you get back when you call the entget function. The difference is that entget returns information about an entity, while entmake builds a new entity from raw data.",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Drawing AutoCAD Entities","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7377.htm"}]},
{"title":"Using the AutoCAD Command Line",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7372.htm",
"description":"When AutoLISP first appeared in AutoCAD, the only available means for entity creation was the command function. This allows an AutoLISP programmer to code just about any command that can be executed from the AutoCAD Command prompt. This is reliable, but it is not as fast as ActiveX methods and does not provide the flexibility of entmake.",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Drawing AutoCAD Entities","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7377.htm"}]},
{"title":"Enabling the Boundary Outline Drawing Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm",
"description":"After the last lesson, the gp:drawOutline function looked like the following:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"}]},
{"title":"Passing Parameters to Functions",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7370.htm",
"description":"A better way to convey information from one function to another is to pass parameters to the called function. Design the function so it expects to receive a number of values. Remember the Degrees->Radians function? This function is passed a parameter named numberOfDegrees:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Working with an Association List",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-736f.htm",
"description":"You can pass the association list in the gp_PathData variable to the gp:drawOutline function by invoking the function as follows:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Using Angles and Setting Up Points",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-736a.htm",
"description":"There are still a couple of issues remaining. First, you need to figure out how to draw the path at any angle the user specifies. From the gp:getPointInput function, you can easily establish the primary angle of the path. To draw it, you need a couple of additional vectors perpendicular to the primary angle.",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Understanding the ActiveX Code in gp:drawOutline",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7367.htm",
"description":"The gp:drawOutline function issues ActiveX calls to display the path\'s polyline border in AutoCAD. The following code fragment uses ActiveX to draw the border:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Ensuring That ActiveX Is Loaded",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7365.htm",
"description":"ActiveX functionality is not automatically enabled when you start AutoCAD or VLISP, so your programs must ensure that ActiveX is loaded. The following function call accomplishes this:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Obtaining a Pointer to Model Space",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7364.htm",
"description":"When you add entities through ActiveX functions, you need to identify the model space or paper space in which the entity is to be inserted. (In ActiveX terminology, entities are objects, but this tutorial will continue using the term entity.) To tell AutoCAD which space the new entities should occupy, you need to obtain a pointer to that space. Unfortunately, obtaining a pointer to model space is not a simple, single-shot function. The following code fragment shows how the operation needs to be set up:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Constructing an Array of Polyline Points",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7363.htm",
"description":"The last issue to deal with is how to transform the individual point variables—p1, p2, p3, and p4—into the format required for the vla-addLightweightpolyline function. First, get some help on the topic.",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Constructing a Variant from a List of Points",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-735f.htm",
"description":"So far, the data in the polypoints variable is in a list format suitable for many AutoLISP calls. However, the data is to be supplied as an input parameter to an ActiveX call that expects a variant array of doubles. You can use another utility function to make the required conversion from list to variant:",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Putting It All Together",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-735d.htm",
"description":"You now have all the code you need to draw the outline of the garden path.",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"},{"title": "Enabling the Boundary Outline Drawing Function","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7371.htm"}]},
{"title":"Wrapping Up Lesson 3",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-735a.htm",
"description":"In this lesson, you",
"ancestors":[{"title": "Drawing the Path Boundary","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5a91.htm"}]},
{"title":"Creating a Project and Adding the Interface",
"href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm",
"description":"In this lesson, you will accomplish two major tasks: creating a Visual LISP® project and adding a dialog-based interface to your application. In the process, you will split the single AutoLISP® file you worked with so far (gpmain.lsp) into several smaller files, reinforcing the concept of code modularity.",
"ancestors":[]},
{"title":"Modularizing Your Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73b1.htm",
"description":"As a result of the work you did in Lesson 3, your gpmain.lsp file was getting rather large. This is not a problem for VLISP, but it is easier to maintain the code if you split things up into files containing logically related functions. It\'s also easier to debug your code. For example, if you have a single file with 150 functions, a single missing parenthesis can be difficult to find.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"}]},
{"title":"Using Visual LISP Projects",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73aa.htm",
"description":"The VLISP project feature provides a convenient way to manage the files that make up your application. And with the project feature, you can open a single project file instead of individually opening every LISP file in the application. Once the project is open, getting to its constituent files is a double-click away.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"}]},
{"title":"Adding the Dialog Box Interface",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73a6.htm",
"description":"The next part of this lesson concerns adding a dialog box interface to the garden path application. To do this, you will be working with another language, dialog control language (DCL).",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"}]},
{"title":"Defining the Dialog Box with DCL",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73a4.htm",
"description":"Begin by taking a look at the dialog box you need to create.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Adding the Dialog Box Interface","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73a6.htm"}]},
{"title":"Saving a DCL File",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-739f.htm",
"description":"Before saving the file containing your DCL, consider the fact that AutoCAD® must be able to locate your DCL file during runtime. For this reason, the file must be placed in one of the AutoCAD Support File Search Path locations. (If you are unsure about these locations, choose Tools Options from the AutoCAD menu and examine the Support File Search Path locations under the Files tab.)",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Adding the Dialog Box Interface","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73a6.htm"}]},
{"title":"Previewing a Dialog Box",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-739c.htm",
"description":"VLISP provides a preview feature for checking the results of your DCL coding.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Adding the Dialog Box Interface","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73a6.htm"}]},
{"title":"Interacting with the Dialog Box from AutoLISP Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm",
"description":"You now need to program your AutoLISP function to interact with the dialog box. The stubbed-out function, gp:getDialogInput, is where this activity will take place. This function now lives in the gp-io.lsp file, which you earlier extracted from gpmain.lsp.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"}]},
{"title":"Setting Up Dialog Values",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7397.htm",
"description":"When you run the complete garden path application, notice that the dialog box always starts up with ActiveX as the default object creation method and Lightweight as the polyline style. Something more interesting occurs with the default tile size—the values change depending on the width of the path. The following code fragment shows how to set up the default values to be displayed in the dialog box:",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Loading the Dialog File",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7396.htm",
"description":"Your program first needs to load the DCL file using the load_dialog function. This function searches for dialog files according to the AutoCAD support file search path, unless you specify a full path name.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Loading a Specific Dialog into Memory",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7395.htm",
"description":"It was noted earlier that a single DCL file may contain multiple dialog box definitions. The next step in using a dialog is to specify which dialog box definition to display. The following code demonstrates this:",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Initializing the Default Dialog Values",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7394.htm",
"description":"If everything worked successfully in loading the dialog, you are ready to start setting up the values that will be displayed to users. A successful load is indicated if the flag variables dialogLoadedanddialogShow are both T (true).",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Assigning Actions to Tiles",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7393.htm",
"description":"A DCL definition does nothing more than define a lifeless dialog box. You connect this lifeless dialog box to your dynamic AutoLISP code with the action_tile function, as demonstrated by the following code:",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Starting the Dialog",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7392.htm",
"description":"The start_dialog function displays a dialog box and accepts user input. The start_dialog function requires no arguments.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Unloading the Dialog",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7391.htm",
"description":"When a user chooses the OK or Cancel button, you need to unload the dialog. Like start_dialog, unload_dialog is another simple function.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Determining What to Do Next",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7390.htm",
"description":"If the user chose OK, you must build a list containing the values set by the user\'s interaction with the dialog. This list is what gp:getDialogInput will return to its calling function. If the user chose Cancel, the function returns nil:",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Putting the Code Together",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-738f.htm",
"description":"With the examples above, and a few additional lines, you have the code needed to complete the gp:getDialogInput function.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Updating a Stubbed-Out Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7389.htm",
"description":"You have now revised the gp:getDialogInput function. Whenever you modify a stubbed-out function, you should always check a couple of things:",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"},{"title": "Interacting with the Dialog Box from AutoLISP Code","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7399.htm"}]},
{"title":"Providing a Choice of Boundary Line Type",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7386.htm",
"description":"One requirement specified for the garden path application was to allow users to draw the boundary outline as either a lightweight polyline or an old-style polyline. The first version of gp:drawOutline you wrote always used a lightweight polyline to draw the boundary. Now that the dialog box interface is ready to go, you can build in the option for drawing an old-style polyline as well. To accomplish this, gp:drawOutline must determine what kind of polyline to draw, and then it must draw it.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"}]},
{"title":"Cleaning Up",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7385.htm",
"description":"If you have not done so already, delete the following code from the C:GPath function in gpmain.lsp:",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"}]},
{"title":"Running the Application",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7384.htm",
"description":"Before running your program, save all the files you changed, if you have not already done so. You can choose File Save All from the VLISP menu, or use the ALT + SHIFT + S keyboard shortcut to save all your open files.",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"}]},
{"title":"Wrapping Up Lesson 4",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-7380.htm",
"description":"In this lesson, you",
"ancestors":[{"title": "Creating a Project and Adding the Interface","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5983.htm"}]},
{"title":"Drawing the Tiles",
"href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm",
"description":"By the end of this lesson, your application will meet the basic requirements stated in Lesson 1. You will add the functionality for drawing tiles within the boundary of the garden path and provide this function using several different methods of entity creation. You will also learn some keyboard shortcuts and new editing tools.",
"ancestors":[]},
{"title":"Introducing More Visual LISP Editing Tools",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73cd.htm",
"description":"Open your copy of gpdraw.lsp in a Visual LISP® text editor window, if the file is not already open. There are a couple of things about this code that are typical of much of the code you will be developing with VLISP. First, there are many parentheses and parentheses within parentheses. Second, there are many function calls, and some of those functions have very long names (vla-addLightweightPolyline, for example). VLISP provides some editing tools to help you deal with these common features of AutoLISP® code.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"}]},
{"title":"Matching Parentheses",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73cc.htm",
"description":"VLISP provides a parenthesis matching feature to help you find the close parenthesis that corresponds to an open parenthesis.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Introducing More Visual LISP Editing Tools","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73cd.htm"}]},
{"title":"Completing a Word Automatically",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73c9.htm",
"description":"Imagine you are adding some new functionality to your program using the following code:",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Introducing More Visual LISP Editing Tools","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73cd.htm"}]},
{"title":"Completing a Word by Apropos",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73c6.htm",
"description":"If you have worked with AutoLISP before, you may have had to type in an expression similar to the one shown below:",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Introducing More Visual LISP Editing Tools","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73cd.htm"}]},
{"title":"Getting Help with a Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73c3.htm",
"description":"The code that adds a lightweight polyline to the drawing calls a function named vla-addLightweightPolyline. Not only is that a lengthy term to write, but there are several functions whose names begin with vla-add that you will use to create entities. Rather than consulting a manual to look up the function name every time you create a program, let VLISP help.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Introducing More Visual LISP Editing Tools","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73cd.htm"}]},
{"title":"Adding Tiles to the Garden Path",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73bf.htm",
"description":"You now have a path boundary and are ready to fill it with tiles. You will need to apply some logic and work through a little geometry.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"}]},
{"title":"Applying Some Logic",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73be.htm",
"description":"One thing you need to do is determine how to space out the tiles and draw them. If this were a simple rectilinear grid of tiles, you could use the AutoCAD® ARRAY command to fill in the tiles. But for the garden path, you need to have each row of tiles offset from the previous row.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Adding Tiles to the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73bf.htm"}]},
{"title":"Applying Some Geometry",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73bc.htm",
"description":"There are only a few dimensions you need to know to draw the garden path. The half-width is easy: it is just half the width of the path. You already defined the code to obtain this width from users and saved it in an association list.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Adding Tiles to the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73bf.htm"}]},
{"title":"Drawing the Rows",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73bb.htm",
"description":"See if you can make sense of the following function. Compare it to the pseudo-code and try to catch the geometric calculations just described. There may be a few AutoLISP functions that are new to you. If you need help with these functions, refer to the AutoLISP Reference. For now, just read the code; do not write anything.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Adding Tiles to the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73bf.htm"}]},
{"title":"Drawing the Tiles in a Row",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73b9.htm",
"description":"Now that you have the logic for drawing the path, the next step is to figure out how to draw the tiles in each row. In the following diagram, there are two cases shown: a row where the offset from the center of the path is equal to 0.0, and a case where the offset is not equal to zero. Take a look at the diagram, then read the pseudo-code that follows.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Adding Tiles to the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73bf.htm"}]},
{"title":"Looking at the Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73b7.htm",
"description":"Now look at the code for the gp:calculate-Draw-TileRow function:",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"},{"title": "Adding Tiles to the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73bf.htm"}]},
{"title":"Testing the Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73b6.htm",
"description":"If you\'ve made it this far, you have earned a shortcut.",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"}]},
{"title":"Wrapping Up Lesson 5",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73b3.htm",
"description":"You started this lesson by learning VLISP editing features that helped you",
"ancestors":[{"title": "Drawing the Tiles","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5873.htm"}]},
{"title":"Acting with Reactors",
"href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm",
"description":"In this lesson, you will learn about reactors and how to attach them to drawing events and entities. Reactors allow your application to be notified by AutoCAD® when particular events occur. For example, if a user moves an entity that your application has attached a reactor to, your application will receive notification that the entity has moved. You can program this to trigger additional operations, such as moving other entities associated with the one the user moved, or perhaps updating a text tag that records revision information on the altered drawing feature. In effect, it is like setting up your application with a pager and telling AutoCAD to beep the application when something happens.",
"ancestors":[]},
{"title":"Reactor Basics",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e7.htm",
"description":"A reactor is an object you attach to the drawing editor, or to specific entities within a drawing. Extending the metaphor of the pager, the reactor object is an automatic dialer that knows how to call your pager when something significant happens. The pager within your application is an AutoLISP® function called by the reactor; such a function is known as a callback function.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"}]},
{"title":"Reactor Types",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e6.htm",
"description":"There are many types of AutoCAD® reactors. Each reactor type responds to one or more AutoCAD events. Reactors are grouped into the following categories:",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Reactor Basics","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e7.htm"}]},
{"title":"Designing Reactors for the Garden Path",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm",
"description":"To implement reactor functionality in the garden path application, start by handling just a few events, rather than trying to cover all possible user actions.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"}]},
{"title":"Selecting Reactor Events for the Garden Path",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e4.htm",
"description":"For the tutorial, set the following goals:",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Designing Reactors for the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm"}]},
{"title":"Planning the Callback Functions",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e2.htm",
"description":"For each reactor event, you must plan the function that will be invoked when the event occurs. The following pseudo-code outlines the logical sequence of events that should occur when users drag one of the polyline vertices to a new location:",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Designing Reactors for the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm"}]},
{"title":"Planning for Multiple Reactors",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e1.htm",
"description":"Users may have several garden paths on the screen, and may be erasing more than one. You need to plan for this possibility.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Designing Reactors for the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm"}]},
{"title":"Attaching the Reactors",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e0.htm",
"description":"The next step in planning a reactor-based application is to determine how and when to attach reactors. You need to attach two object reactors for the polyline border of any garden path (one to respond to a modification event, the other to respond to erasure), and one editor reactor to alert your application when users complete their modification to the polyline. Object reactors are attached to entities, while editor reactors are registered with AutoCAD.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Designing Reactors for the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm"}]},
{"title":"Storing Data with a Reactor",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73df.htm",
"description":"You can solve the problem of saving the original configuration by taking advantage of another feature of VLISP reactors—the ability to store data within a reactor. When the user first draws a path boundary, you attach a reactor to the boundary, along with the data you need to save. This entails modifying your main program function, C:GPath, as follows:",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Designing Reactors for the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm"}]},
{"title":"Updating the C:GPath Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73de.htm",
"description":"Update the C:GPath function by adding reactor creation logic.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Designing Reactors for the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm"}]},
{"title":"Adding Reactor Callback Functions",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73db.htm",
"description":"The reactor callback functions add a substantial amount of code to your application. This code is provided for you in the Lesson6 directory.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Designing Reactors for the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm"}]},
{"title":"Cleaning Up After Your Reactors",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73d7.htm",
"description":"Reactors are indeed very active. When you design an application that relies on them, you could very well spend a great deal of time crashing your program and possibly crashing AutoCAD as well. It helps to have a tool available to remove all the reactors you have added, if necessary.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Designing Reactors for the Garden Path","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73e5.htm"}]},
{"title":"Test Driving Your Reactors",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73d6.htm",
"description":"By now, you should have all the necessary pieces in place to use some live reactors.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"}]},
{"title":"Examining Reactor Behavior in Detail",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73d1.htm",
"description":"With a stack of scrap paper, start tracing the reactor events within the application. Here is an example of the kinds of things you should track:",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"},{"title": "Test Driving Your Reactors","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73d6.htm"}]},
{"title":"Wrapping Up Lesson 6",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-73ce.htm",
"description":"In this lesson, you were introduced to AutoCAD reactors and how to implement them using VLISP. You designed a plan for adding reactors to the garden path application, and added some of the code your program will need to implement the plan.",
"ancestors":[{"title": "Acting with Reactors","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-581a.htm"}]},
{"title":"Putting It All Together",
"href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm",
"description":"In Lesson 6, you learned the basic mechanics behind reactor-based applications. In Lesson 7, you will add functionality to this knowledge and create a garden path that knows how and when to modify itself. After testing your application and determining that it works satisfactorily, you will create a Visual LISP® application from your VLISP project.",
"ancestors":[]},
{"title":"Planning the Overall Reactor Process",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72fa.htm",
"description":"You need to define several new functions in this lesson. Rather than present you with details on all aspects of the new code, this lesson presents an overview and points out the concepts behind the code. At the end of the lesson, you will have all the source code necessary to create a garden path application identical to the sample program you ran in Lesson 1.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"}]},
{"title":"Reacting to More User-Invoked Commands",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72f6.htm",
"description":"When writing a reactor-based application, you need to handle any command that affects your objects in a significant way. One of your program design activities should be to review all possible AutoCAD editing commands and determine how your application should respond to each one. The format of the reactor-trace sheet shown near the end of Lesson 6 is very good for this purpose. Invoke the commands you expect your user to use, and write down the kind of behavior with which your application should respond. Other actions to plan for include",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Planning the Overall Reactor Process","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72fa.htm"}]},
{"title":"Storing Information Within the Reactor Objects",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72f2.htm",
"description":"One other important aspect of the application you need to think about is what kind of information to attach to the object reactor that is created for each polyline entity. In Lesson 6, you added code that attached the contents of gp_PathData (the association list) to the reactor. You expanded the data carried within gp_PathData by adding a new keyed field (100) to the association list. This new sublist is a list of pointers to all the circle entities assigned to a polyline boundary.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Planning the Overall Reactor Process","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72fa.htm"}]},
{"title":"Adding the New Reactor Functionality",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm",
"description":"In Lesson 6, you hooked up callback function gp:command-will-start to the reactor event :vlr-commandWillStart. As it currently exists, the function displays some messages and initializes two global variables, *polyToChange* and *reactorsToRemove*, to nil.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"}]},
{"title":"Adding Activity to the Object Reactor Callback Functions",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72eb.htm",
"description":"In Lesson 6, you registered two callback functions with object reactor events. The gp:outline-erased function was associated with the:vlr-erased reactor event, and gp:outline-changed was associated with the :vlr-modified event. You need to make these functions do what they are intended to do.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Adding the New Reactor Functionality","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm"}]},
{"title":"Designing the gp:command-ended Callback Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72e8.htm",
"description":"The gp:command-ended editor reactor callback function is where most action takes place. Until this function is called, the garden path border polylines are “open for modify;” that is, users may still be manipulating the borders in AutoCAD. Within the reactor sequence, you have to wait until AutoCAD has done its part of the work before you are free to do what you want to do.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Adding the New Reactor Functionality","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm"}]},
{"title":"Handling Multiple Entity Types",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72e7.htm",
"description":"The first detail is that your application may draw two kinds of polylines: old-style and lightweight. These different polyline types return their entity data in different formats. The old-style polyline returns a list of twelve reals: four sets of X, Y, and Z points. The lightweight polyline, though, returns a list eight reals: four sets of X and Y points.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Adding the New Reactor Functionality","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm"}]},
{"title":"Using ActiveX Methods in Reactor Callback Functions",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72e4.htm",
"description":"The second detail appearing in the pseudo-code shows up near the end, at the step for redrawing the tiles. Here is the pseudo-code statement:",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Adding the New Reactor Functionality","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm"}]},
{"title":"Handling Nonlinear Reactor Sequences",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72e3.htm",
"description":"The final important detail deals with a quirk in the command/reactor sequence in AutoCAD when users modify a polyline by using the specialized GRIP commands. These commands, such as GRIP_MOVE and GRIP_ROTATE, are available from a shortcut menu after you select the grip of an object and right-click. The reactor sequence is not as linear as a simple MOVE or ERASE command. In effect, the user is changing to a different command while in the midst of another. To demonstrate this situation, you can load the code from Lesson 6 that traces the sequence of reactor events. Or simply review the following annotated VLISP Console window output to see what happens:",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Adding the New Reactor Functionality","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm"}]},
{"title":"Coding the command-ended Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72e0.htm",
"description":"Now that you have seen the pseudo-code and handled some important details, replace the stubbed-out code in the gp:command-ended reactor callback with the following:",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Adding the New Reactor Functionality","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm"}]},
{"title":"Updating gp:Calculate-and-Draw-Tiles",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72df.htm",
"description":"Earlier in this lesson, it was noted that you need to force gp:Calculate-and-Draw-Tiles to use ActiveX to create objects when invoked from a reactor callback. This means overriding the object creation style (ActiveX, entmake, or command) chosen by the user, if necessary. The code you just updated, in the gp:command-ended function, contains the following invocation of the tile drawing routine:",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Adding the New Reactor Functionality","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm"}]},
{"title":"Modifying Other Calls to gp:Calculate-and-Draw-Tiles",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72dc.htm",
"description":"In the reactor callback, a hard-coded string \"ActiveX\" is passed to gp:Calculate-and-Draw-Tiles as the ObjectCreationStyle argument. But what about the other times gp:Calculate-and-Draw-Tiles is invoked?",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Adding the New Reactor Functionality","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ee.htm"}]},
{"title":"Redefining the Polyline Boundary",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d7.htm",
"description":"You have worked hard to get to this point, and your brain has probably had enough new concepts, terms, commands, and imperatives for a while. With that in mind, it is recommended that you copy the sample code supplied with the tutorial, rather than entering it on your own.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"}]},
{"title":"Looking at the Functions in gppoly.lsp",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d4.htm",
"description":"The file gppoly.lsp contains a number of functions required for straightening a polyline when a single grip has been stretched. Only some of these functions will be explained in depth in this tutorial.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Redefining the Polyline Boundary","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d7.htm"}]},
{"title":"Understanding the gp:RedefinePolyBorder Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d2.htm",
"description":"The following pseudo-code shows the logic behind the main function, gp:RedefinePolyBorder:",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Redefining the Polyline Boundary","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d7.htm"}]},
{"title":"Understanding the gp:FindMovedPoint Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d1.htm",
"description":"The gp:FindMovedPoint function contains some very powerful LISP expressions dealing with list manipulation. Essentially, what this function does is compare the list of the current polyline points (after the user dragged one to a new location) to the previous points, and return the keyed list (the 13 <xvalue> <yvalue>) for the moved point.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Redefining the Polyline Boundary","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d7.htm"}]},
{"title":"Understanding the gp:FindPointInList Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72cf.htm",
"description":"The function header in the source code explains how gp:FindPointInList transforms the information it works with. Like the previous function, Gp:FindMovedPoint, this function uses LISP\'s list manipulation capabilities to perform the work. When operating with lists, you will often see the mapcar and lambda functions used together as they are here. At first, these are strange and confusing functions, with names that do not indicate what they do. Once you learn how to use them, however, you will find them to be two of the most powerful functions within the AutoLISP repertoire. What follows is a brief overview of mapcar and lambda.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Redefining the Polyline Boundary","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d7.htm"}]},
{"title":"Understanding the gp:recalcPolyCorners Function",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72ce.htm",
"description":"The key to understanding how gp:recalcPolyCorners works is to revisit the diagram showing what the key values of 12 through 15 represent:",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Redefining the Polyline Boundary","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d7.htm"}]},
{"title":"Understanding the gp:pointEqual, gp:rtos2, and gp:zeroSmallNum Functions",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72cc.htm",
"description":"These three functions are required to get around one of the quirks of programming in an AutoCAD system, which, as you are well aware, allows you a great deal of precision. Occasionally, though, numbers are not quite precise enough, due to the rounding up or down of floating point values defining geometric positions. You must be able to compare one set of points with other points, so you must deal with these cases.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Redefining the Polyline Boundary","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72d7.htm"}]},
{"title":"Wrapping Up the Code",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72cb.htm",
"description":"So far, you have done the following in this lesson:",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"}]},
{"title":"Building an Application",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72c9.htm",
"description":"The final act within this tutorial is to take your garden path code and turn it into a stand-alone application. This way, it can be distributed as a single executable to any user or customer. Fortunately, this last set of tasks is probably the easiest in this entire tutorial, as VLISP does practically all the work for you.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"}]},
{"title":"Starting the Make Application Wizard",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72c8.htm",
"description":"To assist you in creating standalone applications, VLISP provides the Make Application wizard.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"},{"title": "Building an Application","href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72c9.htm"}]},
{"title":"Wrapping Up the Tutorial",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72c4.htm",
"description":"You have finally made it to the end of the path! As you have discovered, a lot of material was covered in this tutorial. Both AutoLISP concepts and VLISP operations have been introduced. The “garden path revisited” was designed to give you a sampling of many topics and concepts. You might be interested in more information. The following is a brief bibliography of some common LISP and AutoLISP books.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"}]},
{"title":"LISP and AutoLISP Books",
"href":"./filesALT/WS1a9193826455f5ff18cb41610ec0a2e719-72c3.htm",
"description":"Understanding AutoLISP: Programming for Productivity, William Kramer, Autodesk Press, ISBN 0-8273-5832-6.",
"ancestors":[{"title": "Putting It All Together","href":"./filesALT/WSfacf1429558a55de185c428100849a0ab7-5781.htm"}]},
]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEECvA
// SIG // EdTRxVZy/1biJUOhwPigggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQJnx3
// SIG // 7EKj7LQgJEPQOWr3CzBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAU2NBbO9BOmq51OqN0s3H
// SIG // OuFfLnhiLW33/PgfL0OIb5C7VUsrEHLQJOnG5fPE3K+D
// SIG // 9HwoBY3aWeJSS6fMCmms7LouKc5cIhwb4pScrWWFU3oN
// SIG // wJ5P35hgeCBK9ntFGZ2SxnwXiVJL/fwg3S2AsM/2lRTo
// SIG // WJmiOdR7xDLQb2MLvyc=
// SIG // End signature block
